// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Traied Nagios.h                                                                                            ==
// ==                 ===============                                                                                            ==
// ==          Zweck: Hauptdatei des Projekts Traied Nagios                                                                      ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#ifndef	__TRAIED_NAGIOS_H__
#define __TRAIED_NAGIOS_H__

// ================================================================================================================================
// Dateien einfgen
#include <Windows.h>
#include <StdIO.h>
#include <RichEdit.h>
#include <WinINet.h>

// ================================================================================================================================
// Makros
#define		TN_VERSION					("1.1.1")													// Die Version
#define		TN_MAIN						(CTraiedNagios::GetInstance())								// Abkrzung fr Klassenzugriff
#define		TN_GUI						(CTraiedNagios::GetInstance().GetGUI())						// Abkrzung fr Klassenzugriff

// Definitionen
#ifdef		_DEBUG
	#define	TN_DEFINITION_SERVER		"http://monitor1.ackermedia.de/nagios/"						// Voreinstellungen
	#define	TN_DEFINITION_SERVER_CGI	"http://monitor1.ackermedia.de/nagios/cgi-bin/"				// Voreinstellungen
#else
	#define	TN_DEFINITION_SERVER		"http://www.ihr-server.de/nagios/"							// Voreinstellungen
	#define	TN_DEFINITION_SERVER_CGI	"http://www.ihr-server.de/nagios/cgi-bin/"					// Voreinstellungen
#endif

// ================================================================================================================================
// Der Rckgabewert
enum EResult
{
	ER_OK						= 0,																// Alles OK!
	ER_ERROR					= 1,																// Fehler
	ER_INVALID_CALL				= 2,																// Fehlerhafter Aufruf
	ER_NOT_FOUND				= 3,																// Nicht gefunden
	ER_OUT_OF_MEMORY			= 4																	// Kein freier Speicher mehr
};

// ================================================================================================================================
// Programmdateien einfgen
#include "../Res/Resource.h"
#include "Misc.h"
#include "Popup.h"
#include "Config.h"
#include "Network.h"
#include "GUI.h"

// ================================================================================================================================
// Die Hauptklasse
class CTraiedNagios
{
	private:
		// Private Variablen
		BOOL					m_bInitialized;														// Kann die Klasse genutzt werden?
		HINSTANCE				m_hInstance;														// Die Programminstanz

		CNetwork*				m_pNetwork;															// Die Netzwerkklasse
		CGUI*					m_pGUI;																// Die GUIKlasse

		SConfig*				m_pConfig;															// Die Konfigurationsstruktur

		BOOL					m_bIsChecking;														// Prfen wir gerade?

		BOOL					m_bMessageOut;														// Soll beim nchsten Prfen ausgegeben werden?
		int						m_iLastStatus;														// Der letzte Status

		BOOL					m_bDebugOK;															// Soll eine OK-Nachricht beim nchsten Prfen ausgegeben werden (Debug)
		BOOL					m_bDebugUnknown;													// Soll eine Unbekannt-Nachricht beim nchsten Prfen ausgegeben werden (Debug)
		BOOL					m_bDebugWarning;													// Soll eine Warnung beim nchsten Prfen ausgegeben werden (Debug)
		BOOL					m_bDebugError;														// Soll ein Fehler beim nchsten Prfen ausgegeben werden (Debug)

	public:
		// Konstruktor und Destruktor
		CTraiedNagios()			{ ZeroMemory(this, sizeof(CTraiedNagios)); }						// Konstruktor
		~CTraiedNagios()		{ if(m_bInitialized) Exit(); }										// Destruktor

		// ffentliche Funktionen
		EResult					Init(HINSTANCE hInstance);											// Initialisiert das Programm
		EResult					MainLoop();															// Die Hauptschleife
		EResult					Exit();																// Deinitialisiert das Programm
		static CTraiedNagios&	GetInstance();														// Die Singletonmethode

		EResult					Check(BOOL bOut = FALSE);											// Prft, ob alles ok ist
		EResult					Check2();															// Prft, ob alles ok ist (Teil 2)
		EResult					Parse(char* pcResponse);											// Wertet die HTTP-Rckgabe aus

		// Inlinemethoden
		CGUI*					GetGUI() { return m_pGUI; }											// Liefert das Hauptfenster zurck
		HINSTANCE				GetProgramInstance() { return m_hInstance; }						// Gibt die Programminstanz zurck
		SConfig*				GetConfig() { return m_pConfig; }									// Gibt die Konfigurationsstruktur zurck
		EResult					DoWindowProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam) { return m_pGUI->DoWindowProc(hWindow, uiMsg, WParam, LParam); }		// Die Fensterfunktion
		int						GetLastStatus() { return m_iLastStatus; }
		void					SetStatus(int iNewStatus) { m_iLastStatus = iNewStatus; }
		void					DebugOK() { m_bDebugOK = TRUE; }
		void					DebugUnknown() { m_bDebugUnknown = TRUE; }
		void					DebugWarning() { m_bDebugWarning = TRUE; }
		void					DebugError() { m_bDebugError = TRUE; }
};

#endif